' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Partial Class AddMember
  Inherits System.Web.UI.Page

  Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click
    Page.Validate()
    If Page.IsValid Then
      Try
        ' Utwrz nowego uytkownika
        Membership.CreateUser(txtUserName.Text, txtPassword.Text, txtEmailAddress.Text)
        ' Domylnie uczy go testerem. Administrator moe zmodyfikowa pniej przydzielone role.
        Roles.AddUserToRole(txtUserName.Text, "Tester")
        Response.Redirect("Members.aspx")
      Catch mcuex As MembershipCreateUserException
        lblErrorMessage.Visible = True
        Select Case mcuex.StatusCode
          Case MembershipCreateStatus.InvalidPassword
            lblErrorMessage.Text = "Niepoprawne haso. Haso powinno mie dugo co najmniej 7 znakw i zawiera przynajmniej jeden znak nie-alfanumeryczny ( [ ] ! @ # $ itd)."
          Case MembershipCreateStatus.DuplicateEmail
            lblErrorMessage.Text = "Powtrzony adres e-mail. Ten adres jest ju w uyciu"
          Case MembershipCreateStatus.DuplicateUserName
            lblErrorMessage.Text = "Niewaciwa nazwa uytkownika. Ta nazwa jest ju w uyciu "
          Case MembershipCreateStatus.InvalidEmail
            lblErrorMessage.Text = "Niepoprawny adres e-mail."
          Case MembershipCreateStatus.Success
            Response.Redirect("Members.aspx")
        End Select
      End Try
    End If
  End Sub
End Class
